#include <bits/stdc++.h>

using namespace std;
typedef long long ll;

const ll inf=(ll) 4e18;

int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    int n;
    ll W;
    double eps;

    cin >> n >> W >> eps;

    vector<ll> w(n),v(n); // w-weight v-value
    for (int i=0; i<n; i++) {
        cin >> w[i] >> v[i];
    }

    ll Vmax=*max_element(v.begin(), v.end());

    // koeficijent skaliranja
    double k=(eps*Vmax)/n;
    if (k<1e-9) k = 1e-9;

    // skalirane
    vector<int> vs(n);
    int sumV=0;
    for (int i=0; i<n; i++) {
        vs[i]=(int)(v[i]/k);
        sumV+=vs[i];
    }

    // DP
    vector<ll> dp(sumV + 1, inf);
    vector<vector<bool>> take(n, vector<bool>(sumV+1, false));
    dp[0]=0;
    for (int i=0; i<n; i++) {
        for (int s=sumV; s>=vs[i]; s--) {
            if (dp[s-vs[i]]+w[i]<dp[s]) {
                dp[s]=dp[s-vs[i]]+w[i];
                take[i][s]=true;
            }
        }
    }
    int bestS=0;
    for (int s=0; s<=sumV; s++) {
        if (dp[s]<=W) bestS=s;
    }

    // vracanje
    vector<int> chosen;
    int s=bestS;
    for (int i=n-1; i>=0; i--) {
        if (s>=vs[i] && take[i][s]) {
            chosen.push_back(i+1);
            s-=vs[i];
        }
    }
    reverse(chosen.begin(), chosen.end());
    cout << chosen.size() << "\n";
    for (int x:chosen) cout << x << " ";
    cout << "\n";
    return 0;
}